#include <iostream>
#include <string>

#include "Potok.h"
#include "tbb/task_scheduler_init.h"

using namespace std;
using namespace tbb;

int main(int argc, char* argv[])
{
	task_scheduler_init init;
	fstream plik_we("..\\tekst.txt", ios_base::in | ios_base::binary);
	fstream plik_wy("..\\tekst_wynikowy.txt", ios_base::out | ios_base::binary);
	LicznikSlow slowa;

	if (plik_we.bad() || plik_wy.bad()) exit(0);
	pipeline potok;

	FiltrPoczatkowy fp(plik_we);
	potok.add_filter(fp);
	FiltrLicznikaSlow fls(slowa);
	potok.add_filter(fls);
	FiltrRot13 fr;
	potok.add_filter(fr);
	FiltrKoncowy fk(plik_wy);
	potok.add_filter(fk);

	potok.run(FiltrPoczatkowy::iloscFragmentow);
	potok.clear();

	plik_we.close();

	for (LicznikSlow::const_iterator i = slowa.begin(); i != slowa.end(); ++i)
		cout << "\"" << i->first << "\"   " << i->second << endl;
	cin.get();
	return 0;
}

